/* hello.c - Als GBA pong */

#include "keypad.h"
#include <math.h>
#define RGB16(r,g,b)  ((r)+(g<<5)+(b<<10)) 


unsigned short* Screen = (unsigned short*)0x6000000;

int main() {
	char x, y;
	*(unsigned long*)0x4000000 = 0x403; // mode3, bg2 on 

	int mode = 1;
	//0 = no deaths
	//1 = deaths

	//Purple background
	for (x = 0; x<240; x++)   //loop through all x
	{
		for (y = 0; y<160; y++)  //loop through all y
		{
			Screen[x + y * 240] = RGB16(15, 0, 15);
		}
	}

	//y Axis of PONG text
	for (y = 30; y<60; y++)  //loop through all y
	{
		Screen[80 + y * 240] = RGB16(31, 31, 31);
		Screen[120 + y * 240] = RGB16(31, 31, 31);
		Screen[138 + y * 240] = RGB16(31, 31, 31);
	}
	for (y = 30; y < 45; y++)  //loop through all y
	{
		Screen[98 + y * 240] = RGB16(31, 31, 31);
		
	}
	for (y = 30; y < 60; y++)  //loop through all y
	{
		Screen[100 + y * 240] = RGB16(31, 31, 31);
		Screen[118 + y * 240] = RGB16(31, 31, 31);
		Screen[140 + y * 240] = RGB16(31, 31, 31);
	}
	for (y = 45; y < 60; y++)  //loop through all y
	{
		Screen[158 + y * 240] = RGB16(31, 31, 31);
	}

	//X axis of PONG text
	for (x = 80; x<98; x++)   //loop through all x
	{
		Screen[x + 30 * 240] = RGB16(31, 31, 31);
	}
	for (x = 100; x<118; x++)   //loop through all x
	{
		Screen[x + 30 * 240] = RGB16(31, 31, 31);
	}
	for (x = 140; x<158; x++)   //loop through all x
	{
		Screen[x + 30 * 240] = RGB16(31, 31, 31);
	}
	for (x = 150; x<158; x++)   //loop through all x
	{
		Screen[x + 45 * 240] = RGB16(31, 31, 31);
	}
	for (x = 80; x<98; x++)   //loop through all x
	{
		Screen[x + 45 * 240] = RGB16(31, 31, 31);
	}
	for (x = 100; x<118; x++)   //loop through all x
	{
		Screen[x + 60 * 240] = RGB16(31, 31, 31);
	}
	for (x = 140; x<158; x++)   //loop through all x
	{
		Screen[x + 60 * 240] = RGB16(31, 31, 31);
	}
	Screen[121 + 31 * 240] = RGB16(31, 31, 31);
	Screen[121 + 32 * 240] = RGB16(31, 31, 31);
	Screen[122 + 32 * 240] = RGB16(31, 31, 31);
	Screen[122 + 33 * 240] = RGB16(31, 31, 31);
	Screen[123 + 34 * 240] = RGB16(31, 31, 31);
	Screen[123 + 35 * 240] = RGB16(31, 31, 31);
	Screen[124 + 36 * 240] = RGB16(31, 31, 31);
	Screen[124 + 37 * 240] = RGB16(31, 31, 31);
	Screen[125 + 38 * 240] = RGB16(31, 31, 31);
	Screen[126 + 39 * 240] = RGB16(31, 31, 31);
	Screen[126 + 40 * 240] = RGB16(31, 31, 31);
	Screen[127 + 41 * 240] = RGB16(31, 31, 31);
	Screen[128 + 42 * 240] = RGB16(31, 31, 31);
	Screen[128 + 43 * 240] = RGB16(31, 31, 31);
	Screen[129 + 44 * 240] = RGB16(31, 31, 31);
	Screen[130 + 45 * 240] = RGB16(31, 31, 31);
	Screen[130 + 46 * 240] = RGB16(31, 31, 31);
	Screen[131 + 47 * 240] = RGB16(31, 31, 31);
	Screen[132 + 48 * 240] = RGB16(31, 31, 31);
	Screen[132 + 49 * 240] = RGB16(31, 31, 31);
	Screen[133 + 50 * 240] = RGB16(31, 31, 31);
	Screen[134 + 51 * 240] = RGB16(31, 31, 31);
	Screen[134 + 52 * 240] = RGB16(31, 31, 31);
	Screen[135 + 53 * 240] = RGB16(31, 31, 31);
	Screen[136 + 54 * 240] = RGB16(31, 31, 31);
	Screen[136 + 55 * 240] = RGB16(31, 31, 31);
	Screen[137 + 56 * 240] = RGB16(31, 31, 31);
	Screen[138 + 57 * 240] = RGB16(31, 31, 31);
	Screen[138 + 58 * 240] = RGB16(31, 31, 31);

	while (1) {

		if (!((*KEYS) & KEY_START)) {
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(0, 31, 0);
				}
			}
			play(mode);
			break;
		}
	}
	
		
	
}



int play(int mode){
	char x, y;

	int playAPos = 40;
	int playBPos = 100;

	int death = 0;
	
	int scoreA = 0;
	int scoreB = 0;

	double ballX = 120;
	double ballY = 80;
	double ballA = 1;

	double speed = 0.5;

	

										// clear screen, and draw a black back ground
	for (x = 0; x<240; x++)   //loop through all x
	{
		for (y = 0; y<160; y++)  //loop through all y
		{
			Screen[x + y * 240] = RGB16(0, 0, 0);
		}
	}

	//Draw team colours
	
	for (y = 0; y<160; y++)  //loop through all y
	{
		Screen[0 + y * 240] = RGB16(31, 0, 0);
	}
	for (y = 0; y<160; y++)  //loop through all y
	{
		Screen[239 + y * 240] = RGB16(0, 0, 31);
	}
	

	while (1) {

	//Getting user input
	if (!((*KEYS) & KEY_UP)) //Up
		playAPos--; 
	if (!((*KEYS) & KEY_DOWN)) //Down
		playAPos++;

	if (!((*KEYS) & KEY_A)) //Up
		playBPos--;
	if (!((*KEYS) & KEY_B)) //Down
		playBPos++;



	if (playAPos > 138) {
		playAPos = 138;
	}
	if (playAPos < 6) {
		playAPos = 6;
	}

	if (playBPos > 138) {
		playBPos = 138;
	}
	if (playBPos < 6) {
		playBPos = 6;
	}

	//Placing paddles
	paddlePlacer(playAPos, 1);
	paddlePlacer(playBPos, 2);

	//BallPhysics
	death = ballPhysics(&ballX, &ballY, &ballA, playAPos, playBPos, mode, &speed);

	if (death > 0) {
	
		//Adding points based upon winner
		if (death == 1) {
			scoreA++;

			ballA = 4;
			//paints screen red
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(31, 0, 0);
				}
			}
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(0, 0, 0);
				}
			}
		}
		if (death == 2) {
			scoreB++;
			ballA = 1;
			//paints screen blue
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(0, 0, 31);
				}
			}
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(0, 0, 0);
				}
			}
		}

		if (scoreA > 2) {
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(31, 0, 0);
				}
			}
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(0, 0, 0);
				}
			}
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(31, 0, 0);
				}
			}
			return 1;
		}

		if (scoreB > 2) {
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(0, 0, 31);
				}
			}
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(0, 0, 0);
				}
			}
			for (x = 0; x<240; x++)   //loop through all x
			{
				for (y = 0; y<160; y++)  //loop through all y
				{
					Screen[x + y * 240] = RGB16(0, 0, 31);
				}
			}
			return 1;
		}	
		ballX = 120;
		ballY = 80;
		playAPos = 40;
		playBPos = 100;

		speed = 0.5;

		if (scoreA == 1) {
			for (x = 0; x < 10; x++) {
				Screen[x + 1 * 240] = RGB16(31, 0, 0);
				Screen[x + 2 * 240] = RGB16(31, 0, 0);
			}
		}
		if (scoreA == 2) {
			for (x = 0; x < 20; x++) {
				Screen[x + 1 * 240] = RGB16(31, 0, 0);
				Screen[x + 2 * 240] = RGB16(31, 0, 0);
			}
		}

		if (scoreB == 1) {
			for (x = 230; x < 240; x++) {
				Screen[x + 1 * 240] = RGB16(0, 0, 31);
				Screen[x + 2 * 240] = RGB16(0, 0, 31);
			}
		}
		if (scoreB == 2) {
			for (x = 220; x < 240; x++) {
				Screen[x + 1 * 240] = RGB16(0, 0, 31);
				Screen[x + 2 * 240] = RGB16(0, 0, 31);
			}
		}

		//Draw team colours

		for (y = 0; y<160; y++)  //loop through all y
		{
			Screen[0 + y * 240] = RGB16(31, 0, 0);
		}
		for (y = 0; y<160; y++)  //loop through all y
		{
			Screen[239 + y * 240] = RGB16(0, 0, 31);
		}

	}
	

	


	}	//loop forever
}


int ballPhysics(double* x, double* y, double* angle, int playAPos, int playBPos, int mode, double* speed ) {

	double oldX = *x;
	double oldY = *y;

	//Detect paddle direction
	if ((*x > 230) && (*y > playBPos) && (*y < playBPos + 20)) {
		*angle = 6.283 - *angle;
		*speed = *speed + 0.1;
	}
	if ((*x < 10) && (*y > playAPos) && (*y < playAPos + 20)) {
		*angle = 6.283 - *angle;
		*speed = *speed + 0.1;
	}

	//Detect walls and change direction
	if (*x > 238) {
		if (mode == 0) {
			*angle = 6.283 - *angle;
		}
		else {
			return 1;
		}
		
	}
	if (*x < 2) {
		if (mode == 0) {
			*angle = 6.283 - *angle;
		}
		else {
			return 2;
		}
	}

	if (*y > 158) {
		*angle = 3.142 - *angle;
		*speed = *speed + 0.1;
	}
	if (*y < 2) {
		*angle = 3.142 - *angle;
		*speed = *speed + 0.1;
	}

	//calculate movement
	*x = *x + *speed * sin(*angle);
	*y = *y + *speed * cos(*angle);

	placeBall(*x, *y, oldX, oldY);

	return 0;
}

//draws the ball to the screen
int placeBall(double x, double y, double oldX, double oldY) {

	int xi = (int)floor(x);
	int yi = (int)floor(y);
	int oldXi = (int)floor(oldX);
	int oldYi = (int)floor(oldY);

	Screen[xi + yi * 240] = RGB16(31, 31, 31);
	Screen[oldXi + oldYi * 240] = RGB16(0, 0, 0);

	return 0;
}


//Places the paddles on screen in the correct position
int paddlePlacer(int yPos, int player) {

	int paddleSize = 20;
	int y = 0;

	if (player == 1) {
		for (y = 0; y < paddleSize; y++) {
			Screen[10 + (y + yPos) * 240] = RGB16(31, 31, 31);
		}
		for (y = 0 ; y <= 160; y++) {
			if(y > yPos + paddleSize)
				Screen[10 + y * 240] = RGB16(0, 0, 0);
		}
		for (y = 0; y < yPos; y++) {
			Screen[10 + (y) * 240] = RGB16(0, 0, 0);
		}
	}
	else {
		for (y = 0; y < paddleSize; y++) {
			Screen[230 + (y + yPos) * 240] = RGB16(31, 31, 31);
		}
		for (y = 0; y <= 160; y++) {
			if (y > yPos + paddleSize)
				Screen[230 + y * 240] = RGB16(0, 0, 0);
		}
		for (y = 0; y < yPos; y++) {
			Screen[230 + (y) * 240] = RGB16(0, 0, 0);
		}
	}
	


	return 0;
}
